/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.world.features.corrock;

import com.google.common.collect.Lists;
import com.minecraftabnormals.abnormals_core.core.util.GenerationPiece;
import com.minecraftabnormals.endergetic.common.world.configs.CorrockBranchConfig;
import com.minecraftabnormals.endergetic.common.world.features.EEFeatures;
import com.minecraftabnormals.endergetic.common.world.features.corrock.AbstractCorrockFeature;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;

public class CorrockBranchFeature
extends AbstractCorrockFeature<CorrockBranchConfig> {
    private static final SphereReplaceConfig SPHERE_CONFIG = new SphereReplaceConfig((BlockState)CORROCK_BLOCK_STATE.func_179281_c(), FeatureSpread.func_242252_a((int)3), 3, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.field_150377_bs.func_176223_P()}));

    public CorrockBranchFeature(Codec<CorrockBranchConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, CorrockBranchConfig config) {
        int branchCount;
        List<Pair<GenerationPiece, AbstractCorrockFeature.ChorusPlantPart>> branches;
        Pair<GenerationPiece, AbstractCorrockFeature.ChorusPlantPart> firstBranch;
        GenerationPiece firstBranchPiece;
        int baseHeight;
        GenerationPiece basePiece;
        BlockState belowState = world.func_180495_p(pos.func_177977_b());
        if (config.isValidGround(belowState) && (basePiece = this.createBase((IWorld)world, pos, rand, baseHeight = rand.nextInt(4) + 4)).canPlace((IWorld)world) && (firstBranchPiece = (GenerationPiece)(firstBranch = (branches = this.createBranches((IWorld)world, pos, rand, branchCount = rand.nextBoolean() ? 1 : rand.nextInt(3) + 1, baseHeight, config.getCrownChance(), config.getDecoratedBranchChance())).get(0)).getFirst()).canPlace((IWorld)world)) {
            basePiece.place((IWorld)world);
            firstBranchPiece.place((IWorld)world);
            AbstractCorrockFeature.ChorusPlantPart firstChorusPart = (AbstractCorrockFeature.ChorusPlantPart)firstBranch.getSecond();
            if (firstChorusPart != null) {
                firstChorusPart.placeGrowth((IWorld)world, rand);
            }
            for (int i = 1; i < branchCount; ++i) {
                Pair<GenerationPiece, AbstractCorrockFeature.ChorusPlantPart> branch = branches.get(i);
                GenerationPiece branchPiece = (GenerationPiece)branch.getFirst();
                if (!branchPiece.canPlace((IWorld)world)) continue;
                branchPiece.place((IWorld)world);
                AbstractCorrockFeature.ChorusPlantPart chorusPlantPart = (AbstractCorrockFeature.ChorusPlantPart)branch.getSecond();
                if (chorusPlantPart == null) continue;
                chorusPlantPart.placeGrowth((IWorld)world, rand);
            }
            BlockPos groundModifierPos = new BlockPos(pos.func_177958_n() - 1 + (rand.nextInt(3) - rand.nextInt(3)), pos.func_177956_o() - 1, pos.func_177952_p() - 1 + (rand.nextInt(3) - rand.nextInt(3)));
            ((Feature)EEFeatures.GROUND_PATCH.get()).func_241855_a(world, generator, rand, groundModifierPos, (IFeatureConfig)SPHERE_CONFIG);
            BlockPos.Mutable corrockPlantPos = new BlockPos.Mutable();
            for (int x = pos.func_177958_n() - 4; x < pos.func_177958_n() + 4; ++x) {
                for (int y = pos.func_177956_o(); y < pos.func_177956_o() + baseHeight + 10; ++y) {
                    for (int z = pos.func_177952_p() - 4; z < pos.func_177952_p() + 4; ++z) {
                        boolean isCorrockBelow;
                        corrockPlantPos.func_181079_c(x, y, z);
                        boolean bl = isCorrockBelow = world.func_180495_p(corrockPlantPos.func_177977_b()).func_177230_c() == EEBlocks.CORROCK_END_BLOCK.get();
                        if (!(isCorrockBelow && rand.nextFloat() < 0.5f) && (isCorrockBelow || !(rand.nextFloat() < 0.025f)) || !world.func_175623_d((BlockPos)corrockPlantPos) || !((BlockState)CORROCK_STATE.func_179281_c()).func_196955_c((IWorldReader)world, (BlockPos)corrockPlantPos)) continue;
                        world.func_180501_a((BlockPos)corrockPlantPos, (BlockState)CORROCK_STATE.func_179281_c(), 2);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private GenerationPiece createBase(IWorld world, BlockPos pos, Random rand, int height) {
        GenerationPiece piece = new GenerationPiece((iworld, part) -> iworld.func_175623_d(part.pos));
        BlockState corrockState = (BlockState)CORROCK_BLOCK_STATE.func_179281_c();
        int heightMinusOne = height - 1;
        BlockPos topPos = pos.func_177981_b(height);
        for (int y = 0; y < height; ++y) {
            piece.addBlockPiece(corrockState, pos.func_177981_b(y));
            if (y != heightMinusOne || !(rand.nextFloat() < 0.85f)) continue;
            piece.addBlockPiece(this.randomStandingCorrockCrown(rand), topPos);
        }
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        int startX = posX - 1;
        int startZ = posZ - 1;
        int endX = posX + 1;
        int endZ = posZ + 1;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                if (!(rand.nextFloat() < 0.4f)) continue;
                mutable.func_181079_c(x, posY, z);
                if (!this.tryToMakeAreaBelowPlacableOn(piece, world, (BlockPos)mutable)) continue;
                int randSideHeight = rand.nextInt(heightMinusOne) + 1;
                for (int y = 0; y < randSideHeight; ++y) {
                    piece.addBlockPiece(corrockState, mutable.func_177981_b(y));
                }
            }
        }
        return piece;
    }

    private boolean tryToMakeAreaBelowPlacableOn(GenerationPiece piece, IWorld world, BlockPos pos) {
        BlockState corrockState = (BlockState)CORROCK_BLOCK_STATE.func_179281_c();
        BlockPos down = pos.func_177977_b();
        if (world.func_175623_d(down) && !world.func_175623_d(pos.func_177979_c(3))) {
            piece.addBlockPiece(corrockState, down);
            BlockPos doubleDown = pos.func_177979_c(2);
            if (world.func_175623_d(doubleDown)) {
                piece.addBlockPiece(corrockState, doubleDown);
            }
            return true;
        }
        return false;
    }

    private List<Pair<GenerationPiece, AbstractCorrockFeature.ChorusPlantPart>> createBranches(IWorld world, BlockPos pos, Random rand, int count, int height, float crownChance, float decorationChance) {
        ArrayList pieces = Lists.newArrayList();
        BlockPos branchStart = pos.func_177981_b(height - 1);
        for (int i = 0; i < count; ++i) {
            GenerationPiece basePiece = new GenerationPiece((iworld, part) -> world.func_175623_d(part.pos));
            pieces.add(new Pair((Object)basePiece, (Object)this.createBranch(world, branchStart, rand, basePiece, this.randomHorizontalDirection(rand), rand.nextInt(2) + 1, crownChance, decorationChance)));
        }
        return pieces;
    }

    @Nullable
    private AbstractCorrockFeature.ChorusPlantPart createBranch(IWorld world, BlockPos pos, Random rand, GenerationPiece basePiece, Direction horizontalStep, int subBranches, float crownChance, float decorationChance) {
        AbstractCorrockFeature.ChorusPlantPart chorusPlantPart = null;
        int branched = 0;
        int prevBranchHeight = 0;
        int branchHeight = rand.nextInt(3) + 4;
        BlockPos offset = pos.func_177972_a(horizontalStep);
        BlockState corrockState = (BlockState)CORROCK_BLOCK_STATE.func_179281_c();
        for (int y = 0; y < branchHeight; ++y) {
            boolean beforeLastBranched;
            boolean lastBranched;
            basePiece.addBlockPiece(corrockState, offset.func_177981_b(y));
            if (y != branchHeight - 1) continue;
            boolean bl = lastBranched = branched == subBranches;
            if (rand.nextFloat() < decorationChance) {
                BlockPos crownOrigin = offset.func_177981_b(y);
                this.createCrownOrbit(basePiece, world, crownOrigin, rand, crownChance);
                if (lastBranched) {
                    chorusPlantPart = new AbstractCorrockFeature.ChorusPlantPart(crownOrigin);
                    break;
                }
            } else if (lastBranched) break;
            if (rand.nextFloat() > 0.6f) {
                horizontalStep = rand.nextBoolean() ? horizontalStep.func_176746_e() : horizontalStep.func_176735_f();
            }
            boolean bl2 = beforeLastBranched = branched == subBranches - 1;
            if (beforeLastBranched) {
                int middle = prevBranchHeight + (branchHeight - prevBranchHeight) / 2;
                y -= branchHeight - middle;
                branchHeight = middle;
                basePiece.addBlockPiece(corrockState, offset.func_177981_b(branchHeight).func_177972_a(horizontalStep));
                offset = offset.func_177967_a(horizontalStep, 2);
            } else {
                offset = offset.func_177972_a(horizontalStep);
                --y;
            }
            prevBranchHeight = --branchHeight;
            branchHeight += rand.nextInt(3) + 4;
            ++branched;
        }
        return chorusPlantPart;
    }

    private void createCrownOrbit(GenerationPiece branch, IWorld world, BlockPos pos, Random rand, float crownChance) {
        for (Direction horizontal : Direction.Plane.HORIZONTAL) {
            BlockPos placingPos = pos.func_177972_a(horizontal);
            if (!(rand.nextFloat() < crownChance) || !world.func_175623_d(placingPos)) continue;
            branch.addBlockPiece(CorrockBranchFeature.getCorrockCrownWall(horizontal), placingPos);
        }
        if (rand.nextFloat() < crownChance && world.func_175623_d(pos.func_177984_a())) {
            branch.addBlockPiece(this.randomStandingCorrockCrown(rand), pos.func_177984_a());
        }
    }

    private Direction randomHorizontalDirection(Random rand) {
        return Direction.func_176731_b((int)rand.nextInt(6));
    }

    private BlockState randomStandingCorrockCrown(Random rand) {
        return CorrockBranchFeature.getCorrockCrownStanding(rand.nextInt(16));
    }
}

